﻿var editUser = {
    context: $(".v-editUser"),
    initializeAutoCompletes: function () {
        $("#CompanyName", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetCompaniesForDropDown", "Reporting", "Settings"),
            altValueField: $("#CompanyId", editUser.context)
        });

        $(".v-groupsAutocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetGroupsForDropDown", "Reporting", "Settings"),
            altValueField: $("#GroupIds", editUser.context),
            multipleSelection: true,
            hideSelectedItems: true
        });

        $(".v-portalsAutocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPortalsForDropDown", "Reporting", "Settings"),
            altValueField: $("#PortalIds", editUser.context),
            multipleSelection: true,
            select: function (event, data) {
                if (data && data.item) {
                    var selectedItem = $(".v-portalsSection .selected-item[data-value=" + data.item["Value"] + "]", editUser.context);

                    if ($(".v-portalsSection .selected-item", editUser.context).length == 1) {
                        editUser.setDefaultPortal(selectedItem);
                    }
                }
            },
            removeItem: function (event, data) {
                if ($("#DefaultPortalId", editUser.context).val() == data.item["Value"]) {
                    editUser.setDefaultPortal(null);
                }
            },
            create: function () {
                var defaultPortalId = $("#DefaultPortalId").val();

                if (defaultPortalId && defaultPortalId > 0) {
                    var defaultItem = $(".v-portalsSection .selected-item[data-value=" + defaultPortalId + "]", editUser.context);

                    if (defaultItem.length > 0) {
                        editUser.setDefaultPortal(defaultItem);
                    }
                }
            }
        });
    },
    bindEvents: function () {
        $(".v-portalsSection", this.context).on("click", ".selected-item", function (e) {
            editUser.setDefaultPortal($(this));
        });
    },
    setDefaultPortal: function (item) {
        var portalsSection = $(".v-portalsSection", this.context);

        if (item) {
            $(".selected-item", portalsSection).removeClass("default");
            item.addClass("default");

            $("#DefaultPortalId", portalsSection).val(item.attr("data-value"));
            $("#DefaultPortalLabel", portalsSection).html($(item).text());
        }
        else {
            $("#DefaultPortalId", portalsSection).val("");
            $("#DefaultPortalLabel", portalsSection).html("");
        }
    }
}

$(document).ready(function () {
    if (editUser.context.length > 0) {
        editUser.initializeAutoCompletes();
        editUser.bindEvents();
    }
});